﻿using System;
using System.Web.UI;
using Microsoft.SharePoint;

namespace RunWithElevatedPrivileges.VisualWebPart1
{
   public partial class VisualWebPart1UserControl : UserControl
   {
      protected void Page_Load(object sender, EventArgs e)
      {
         // Windows-Identität: CONTOSO\UserA
         // SharePoint-Identität: CONTOSO\UserA

         // Kontext der aktuelle Site Collection beschaffen
         SPSite currentSite = SPContext.Current.Site;

         lblSPIdentity.Text = currentSite.RootWeb.CurrentUser.LoginName;

         // Code mit heraufgestuften Privilegien ausführen
         SPSecurity.RunWithElevatedPrivileges(delegate()
         {
            // Es muss (!!!) ein neues SPSite-Objekt erzeugt werden
            using (SPSite elevatedSite = new SPSite(currentSite.ID))
            {
               lblSPIdentityElevated.Text = elevatedSite.RootWeb.CurrentUser.LoginName;

               using (SPWeb elevatedWeb = elevatedSite.OpenWeb())
               {
                  // Windows-Identität: CONTOSO\sp_app_teamsite
                  // SharePoint-Identität: SHAREPOINT\system

                  // Benutzer impersonfizieren
                  string impersonatedUserName = "CONTOSO\\UserB";
                  elevatedWeb.EnsureUser(impersonatedUserName);
                  SPUser impersonatedUser =
                     elevatedWeb.SiteUsers[impersonatedUserName];

                  // Token des Benutzers auslesen
                  SPUserToken impersonatedUserToken =
                     impersonatedUser.UserToken;

                  // Erzeugung eines neuen SPSite-Objekts
                  // für den impersonifizierten Benutzer
                  using (SPSite impersonatedSite =
                     new SPSite(elevatedSite.ID, impersonatedUserToken))
                  {
                     using (SPWeb impersonatedWeb = impersonatedSite.RootWeb)
                     {
                        // SharePoint-Identität des impersonifizierten Benutzers
                        SPUser impersonatedUserIdentity =
                           impersonatedWeb.CurrentUser;

                        lblSPIdentityImpersonated.Text = impersonatedUserIdentity.LoginName;
                        // Windows-Identität: CONTOSO\UserB
                        // SharePoint-Identität: SHAREPOINT\UserB
                     }
                  }
               }
            }
         });
      }
   }
}